package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookNamedItem;
import odata.msgraph.client.beta.entity.WorkbookRange;

@JsonIgnoreType
public class WorkbookNamedItemRequest extends EntityRequest<WorkbookNamedItem> {

    public WorkbookNamedItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookNamedItem.class, contextPath, value, false);
    }

    public WorkbookWorksheetRequest worksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.empty());
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

}
