package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartSeriesFormat;

@JsonIgnoreType
public class WorkbookChartSeriesFormatRequest extends EntityRequest<WorkbookChartSeriesFormat> {

    public WorkbookChartSeriesFormatRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChartSeriesFormat.class, contextPath, value, false);
    }

    public WorkbookChartFillRequest fill() {
        return new WorkbookChartFillRequest(contextPath.addSegment("fill"), Optional.empty());
    }

    public WorkbookChartLineFormatRequest line() {
        return new WorkbookChartLineFormatRequest(contextPath.addSegment("line"), Optional.empty());
    }

}
