package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.WorkbookChart;
import odata.msgraph.client.beta.entity.collection.request.WorkbookChartSeriesCollectionRequest;

@JsonIgnoreType
public class WorkbookChartRequest extends EntityRequest<WorkbookChart> {

    public WorkbookChartRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChart.class, contextPath, value, false);
    }

    public WorkbookChartAxesRequest axes() {
        return new WorkbookChartAxesRequest(contextPath.addSegment("axes"), Optional.empty());
    }

    public WorkbookChartDataLabelsRequest dataLabels() {
        return new WorkbookChartDataLabelsRequest(contextPath.addSegment("dataLabels"), Optional.empty());
    }

    public WorkbookChartAreaFormatRequest format() {
        return new WorkbookChartAreaFormatRequest(contextPath.addSegment("format"), Optional.empty());
    }

    public WorkbookChartLegendRequest legend() {
        return new WorkbookChartLegendRequest(contextPath.addSegment("legend"), Optional.empty());
    }

    public WorkbookChartSeriesRequest series(String id) {
        return new WorkbookChartSeriesRequest(contextPath.addSegment("series").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookChartSeriesCollectionRequest series() {
        return new WorkbookChartSeriesCollectionRequest(
                        contextPath.addSegment("series"), Optional.empty());
    }

    public WorkbookChartTitleRequest title() {
        return new WorkbookChartTitleRequest(contextPath.addSegment("title"), Optional.empty());
    }

    public WorkbookWorksheetRequest worksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.empty());
    }

    @Action(name = "setData")
    @JsonIgnore
    public ActionRequestNoReturn setData(Json sourceData, String seriesBy) {
        Preconditions.checkNotNull(seriesBy, "seriesBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceData", "microsoft.graph.Json", sourceData)
            .put("seriesBy", "Edm.String", Checks.checkIsAscii(seriesBy))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setData"), _parameters);
    }

    @Action(name = "setPosition")
    @JsonIgnore
    public ActionRequestNoReturn setPosition(Json startCell, Json endCell) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startCell", "microsoft.graph.Json", startCell)
            .put("endCell", "microsoft.graph.Json", endCell)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPosition"), _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function(Integer width) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function_(Integer width, Integer height) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Preconditions.checkNotNull(height, "height cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .put("height", "Edm.Int32", height)
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function__(Integer width, Integer height, String fittingMode) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Preconditions.checkNotNull(height, "height cannot be null");
        Preconditions.checkNotNull(fittingMode, "fittingMode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .put("height", "Edm.Int32", height)
            .put("fittingMode", "Edm.String", Checks.checkIsAscii(fittingMode))
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

}
