package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartFill;

@JsonIgnoreType
public class WorkbookChartFillRequest extends EntityRequest<WorkbookChartFill> {

    public WorkbookChartFillRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChartFill.class, contextPath, value, false);
    }

    @Action(name = "clear")
    @JsonIgnore
    public ActionRequestNoReturn clear() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clear"), _parameters);
    }

    @Action(name = "setSolidColor")
    @JsonIgnore
    public ActionRequestNoReturn setSolidColor(String color) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("color", "Edm.String", Checks.checkIsAscii(color))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setSolidColor"), _parameters);
    }

}
