package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartAxis;

@JsonIgnoreType
public class WorkbookChartAxisRequest extends EntityRequest<WorkbookChartAxis> {

    public WorkbookChartAxisRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookChartAxis.class, contextPath, value, false);
    }

    public WorkbookChartAxisFormatRequest format() {
        return new WorkbookChartAxisFormatRequest(contextPath.addSegment("format"), Optional.empty());
    }

    public WorkbookChartGridlinesRequest majorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("majorGridlines"), Optional.empty());
    }

    public WorkbookChartGridlinesRequest minorGridlines() {
        return new WorkbookChartGridlinesRequest(contextPath.addSegment("minorGridlines"), Optional.empty());
    }

    public WorkbookChartAxisTitleRequest title() {
        return new WorkbookChartAxisTitleRequest(contextPath.addSegment("title"), Optional.empty());
    }

}
