package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsUpdateForBusinessConfiguration;
import odata.msgraph.client.beta.entity.collection.request.WindowsUpdateStateCollectionRequest;

@JsonIgnoreType
public class WindowsUpdateForBusinessConfigurationRequest extends EntityRequest<WindowsUpdateForBusinessConfiguration> {

    public WindowsUpdateForBusinessConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsUpdateForBusinessConfiguration.class, contextPath, value, false);
    }

    public WindowsUpdateStateRequest deviceUpdateStates(String id) {
        return new WindowsUpdateStateRequest(contextPath.addSegment("deviceUpdateStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsUpdateStateCollectionRequest deviceUpdateStates() {
        return new WindowsUpdateStateCollectionRequest(
                        contextPath.addSegment("deviceUpdateStates"), Optional.empty());
    }

    @Action(name = "extendFeatureUpdatesPause")
    @JsonIgnore
    public ActionRequestNoReturn extendFeatureUpdatesPause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.extendFeatureUpdatesPause"), _parameters);
    }

    @Action(name = "extendQualityUpdatesPause")
    @JsonIgnore
    public ActionRequestNoReturn extendQualityUpdatesPause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.extendQualityUpdatesPause"), _parameters);
    }

}
