package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsProtectionState;
import odata.msgraph.client.beta.entity.collection.request.WindowsDeviceMalwareStateCollectionRequest;

@JsonIgnoreType
public class WindowsProtectionStateRequest extends EntityRequest<WindowsProtectionState> {

    public WindowsProtectionStateRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsProtectionState.class, contextPath, value, false);
    }

    public WindowsDeviceMalwareStateRequest detectedMalwareState(String id) {
        return new WindowsDeviceMalwareStateRequest(contextPath.addSegment("detectedMalwareState").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDeviceMalwareStateCollectionRequest detectedMalwareState() {
        return new WindowsDeviceMalwareStateCollectionRequest(
                        contextPath.addSegment("detectedMalwareState"), Optional.empty());
    }

}
