package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfile;
import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfileAssignment;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileAssignmentCollectionRequest;

@JsonIgnoreType
public class WindowsFeatureUpdateProfileRequest extends EntityRequest<WindowsFeatureUpdateProfile> {

    public WindowsFeatureUpdateProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsFeatureUpdateProfile.class, contextPath, value, false);
    }

    public WindowsFeatureUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsFeatureUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsFeatureUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsFeatureUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsFeatureUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsFeatureUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
