package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsDefenderApplicationControlSupplementalPolicy;
import odata.msgraph.client.beta.entity.WindowsDefenderApplicationControlSupplementalPolicyAssignment;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest;

@JsonIgnoreType
public class WindowsDefenderApplicationControlSupplementalPolicyRequest extends EntityRequest<WindowsDefenderApplicationControlSupplementalPolicy> {

    public WindowsDefenderApplicationControlSupplementalPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsDefenderApplicationControlSupplementalPolicy.class, contextPath, value, false);
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest assignments(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest assignments() {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest deploySummary() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest(contextPath.addSegment("deploySummary"), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest deviceStatuses(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest deviceStatuses() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsDefenderApplicationControlSupplementalPolicyAssignment> wdacPolicyAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("wdacPolicyAssignments", "Collection(microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyAssignment)", wdacPolicyAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
