package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsAutopilotDeploymentProfile;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;

@JsonIgnoreType
public class WindowsAutopilotDeploymentProfileRequest extends EntityRequest<WindowsAutopilotDeploymentProfile> {

    public WindowsAutopilotDeploymentProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(WindowsAutopilotDeploymentProfile.class, contextPath, value, false);
    }

    public WindowsAutopilotDeviceIdentityRequest assignedDevices(String id) {
        return new WindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("assignedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsAutopilotDeviceIdentityCollectionRequest assignedDevices() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("assignedDevices"), Optional.empty());
    }

    public WindowsAutopilotDeploymentProfileAssignmentRequest assignments(String id) {
        return new WindowsAutopilotDeploymentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsAutopilotDeploymentProfileAssignmentCollectionRequest assignments() {
        return new WindowsAutopilotDeploymentProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<String> deviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
