package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Windows81SCEPCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;

@JsonIgnoreType
public class Windows81SCEPCertificateProfileRequest extends EntityRequest<Windows81SCEPCertificateProfile> {

    public Windows81SCEPCertificateProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Windows81SCEPCertificateProfile.class, contextPath, value, false);
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"), Optional.empty());
    }

    public Windows81TrustedRootCertificateRequest rootCertificate() {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificate"), Optional.empty());
    }

}
