package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.VppToken;

@JsonIgnoreType
public class VppTokenRequest extends EntityRequest<VppToken> {

    public VppTokenRequest(ContextPath contextPath, Optional<Object> value) {
        super(VppToken.class, contextPath, value, false);
    }

    @Action(name = "revokeLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeLicenses(Boolean notifyManagedDevices, Boolean revokeUntrackedLicenses) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .put("revokeUntrackedLicenses", "Edm.Boolean", revokeUntrackedLicenses)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeLicenses"), _parameters);
    }

    @Action(name = "syncLicenses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<VppToken> syncLicenses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<VppToken>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncLicenses"), VppToken.class, _parameters);
    }

}
