package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.VirtualEndpoint;
import odata.msgraph.client.beta.entity.collection.request.CloudPCCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcAuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcDeviceImageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcGalleryImageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcOnPremisesConnectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcProvisioningPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcServicePlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcSnapshotCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcSupportedRegionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcUserSettingCollectionRequest;

@JsonIgnoreType
public class VirtualEndpointRequest extends EntityRequest<VirtualEndpoint> {

    public VirtualEndpointRequest(ContextPath contextPath, Optional<Object> value) {
        super(VirtualEndpoint.class, contextPath, value, false);
    }

    public CloudPcAuditEventRequest auditEvents(String id) {
        return new CloudPcAuditEventRequest(contextPath.addSegment("auditEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcAuditEventCollectionRequest auditEvents() {
        return new CloudPcAuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.empty());
    }

    public CloudPCRequest cloudPCs(String id) {
        return new CloudPCRequest(contextPath.addSegment("cloudPCs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPCCollectionRequest cloudPCs() {
        return new CloudPCCollectionRequest(
                        contextPath.addSegment("cloudPCs"), Optional.empty());
    }

    public CloudPcDeviceImageRequest deviceImages(String id) {
        return new CloudPcDeviceImageRequest(contextPath.addSegment("deviceImages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcDeviceImageCollectionRequest deviceImages() {
        return new CloudPcDeviceImageCollectionRequest(
                        contextPath.addSegment("deviceImages"), Optional.empty());
    }

    public CloudPcGalleryImageRequest galleryImages(String id) {
        return new CloudPcGalleryImageRequest(contextPath.addSegment("galleryImages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcGalleryImageCollectionRequest galleryImages() {
        return new CloudPcGalleryImageCollectionRequest(
                        contextPath.addSegment("galleryImages"), Optional.empty());
    }

    public CloudPcOnPremisesConnectionRequest onPremisesConnections(String id) {
        return new CloudPcOnPremisesConnectionRequest(contextPath.addSegment("onPremisesConnections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcOnPremisesConnectionCollectionRequest onPremisesConnections() {
        return new CloudPcOnPremisesConnectionCollectionRequest(
                        contextPath.addSegment("onPremisesConnections"), Optional.empty());
    }

    public CloudPcOrganizationSettingsRequest organizationSettings() {
        return new CloudPcOrganizationSettingsRequest(contextPath.addSegment("organizationSettings"), Optional.empty());
    }

    public CloudPcProvisioningPolicyRequest provisioningPolicies(String id) {
        return new CloudPcProvisioningPolicyRequest(contextPath.addSegment("provisioningPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcProvisioningPolicyCollectionRequest provisioningPolicies() {
        return new CloudPcProvisioningPolicyCollectionRequest(
                        contextPath.addSegment("provisioningPolicies"), Optional.empty());
    }

    public CloudPcServicePlanRequest servicePlans(String id) {
        return new CloudPcServicePlanRequest(contextPath.addSegment("servicePlans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcServicePlanCollectionRequest servicePlans() {
        return new CloudPcServicePlanCollectionRequest(
                        contextPath.addSegment("servicePlans"), Optional.empty());
    }

    public CloudPcSnapshotRequest snapshots(String id) {
        return new CloudPcSnapshotRequest(contextPath.addSegment("snapshots").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcSnapshotCollectionRequest snapshots() {
        return new CloudPcSnapshotCollectionRequest(
                        contextPath.addSegment("snapshots"), Optional.empty());
    }

    public CloudPcSupportedRegionRequest supportedRegions(String id) {
        return new CloudPcSupportedRegionRequest(contextPath.addSegment("supportedRegions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcSupportedRegionCollectionRequest supportedRegions() {
        return new CloudPcSupportedRegionCollectionRequest(
                        contextPath.addSegment("supportedRegions"), Optional.empty());
    }

    public CloudPcUserSettingRequest userSettings(String id) {
        return new CloudPcUserSettingRequest(contextPath.addSegment("userSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPcUserSettingCollectionRequest userSettings() {
        return new CloudPcUserSettingCollectionRequest(
                        contextPath.addSegment("userSettings"), Optional.empty());
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters);
    }

}
