package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Vendor;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;

@JsonIgnoreType
public class VendorRequest extends EntityRequest<Vendor> {

    public VendorRequest(ContextPath contextPath, Optional<Object> value) {
        super(Vendor.class, contextPath, value, false);
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.empty());
    }

    public PaymentMethodRequest paymentMethod() {
        return new PaymentMethodRequest(contextPath.addSegment("paymentMethod"), Optional.empty());
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.empty());
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.empty());
    }

}
