package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.graph.security.entity.request.SecurityEntityRequest;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.AttendeeBase;
import odata.msgraph.client.beta.complex.ConvertIdResult;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementData;
import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.complex.LocationConstraint;
import odata.msgraph.client.beta.complex.MailTips;
import odata.msgraph.client.beta.complex.ManagedAppDiagnosticStatus;
import odata.msgraph.client.beta.complex.ManagedDeviceSummarizedAppState;
import odata.msgraph.client.beta.complex.MeetingTimeSuggestionsResult;
import odata.msgraph.client.beta.complex.Reminder;
import odata.msgraph.client.beta.complex.TimeConstraint;
import odata.msgraph.client.beta.entity.DeviceEnrollmentConfiguration;
import odata.msgraph.client.beta.entity.ManagedAppPolicy;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.Message;
import odata.msgraph.client.beta.entity.User;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppConsentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppIntentAndStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OAuth2PermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsageRightCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.enums.ExchangeIdFormat;
import odata.msgraph.client.beta.enums.MailTipsType;

@JsonIgnoreType
public class UserRequest extends EntityRequest<User> {

    public UserRequest(ContextPath contextPath, Optional<Object> value) {
        super(User.class, contextPath, value, false);
    }

    public UserAnalyticsRequest analytics() {
        return new UserAnalyticsRequest(contextPath.addSegment("analytics"), Optional.empty());
    }

    public UsageRightRequest usageRights(String id) {
        return new UsageRightRequest(contextPath.addSegment("usageRights").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UsageRightCollectionRequest usageRights() {
        return new UsageRightCollectionRequest(
                        contextPath.addSegment("usageRights"), Optional.empty());
    }

    public InformationProtectionRequest informationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"), Optional.empty());
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"), Optional.empty());
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"), Optional.empty());
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directReports"), Optional.empty());
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"), Optional.empty());
    }

    public DirectoryObjectRequest manager() {
        return new DirectoryObjectRequest(contextPath.addSegment("manager"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(
                        contextPath.addSegment("oauth2PermissionGrants"), Optional.empty());
    }

    public DirectoryObjectRequest ownedDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedDevices"), Optional.empty());
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"), Optional.empty());
    }

    public DirectoryObjectRequest registeredDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest registeredDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredDevices"), Optional.empty());
    }

    public ScopedRoleMembershipRequest scopedRoleMemberOf(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveReports"), Optional.empty());
    }

    public CalendarRequest calendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"), Optional.empty());
    }

    public CalendarGroupRequest calendarGroups(String id) {
        return new CalendarGroupRequest(contextPath.addSegment("calendarGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarGroupCollectionRequest calendarGroups() {
        return new CalendarGroupCollectionRequest(
                        contextPath.addSegment("calendarGroups"), Optional.empty());
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"), Optional.empty());
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"), Optional.empty());
    }

    public ContactFolderRequest contactFolders(String id) {
        return new ContactFolderRequest(contextPath.addSegment("contactFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContactFolderCollectionRequest contactFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("contactFolders"), Optional.empty());
    }

    public ContactRequest contacts(String id) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContactCollectionRequest contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"), Optional.empty());
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"), Optional.empty());
    }

    public InferenceClassificationRequest inferenceClassification() {
        return new InferenceClassificationRequest(contextPath.addSegment("inferenceClassification"), Optional.empty());
    }

    public GroupRequest joinedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("joinedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest joinedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("joinedGroups"), Optional.empty());
    }

    public MailFolderRequest mailFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("mailFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MailFolderCollectionRequest mailFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("mailFolders"), Optional.empty());
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.empty());
    }

    public OutlookUserRequest outlook() {
        return new OutlookUserRequest(contextPath.addSegment("outlook"), Optional.empty());
    }

    public PersonRequest people(String id) {
        return new PersonRequest(contextPath.addSegment("people").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonCollectionRequest people() {
        return new PersonCollectionRequest(
                        contextPath.addSegment("people"), Optional.empty());
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.empty());
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"), Optional.empty());
    }

    public SiteRequest followedSites(String id) {
        return new SiteRequest(contextPath.addSegment("followedSites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteCollectionRequest followedSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("followedSites"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public AppConsentRequestRequest appConsentRequestsForApproval(String id) {
        return new AppConsentRequestRequest(contextPath.addSegment("appConsentRequestsForApproval").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppConsentRequestCollectionRequest appConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(
                        contextPath.addSegment("appConsentRequestsForApproval"), Optional.empty());
    }

    public ApprovalRequest approvals(String id) {
        return new ApprovalRequest(contextPath.addSegment("approvals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalCollectionRequest approvals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("approvals"), Optional.empty());
    }

    public AccessReviewInstanceRequest pendingAccessReviewInstances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("pendingAccessReviewInstances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceCollectionRequest pendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("pendingAccessReviewInstances"), Optional.empty());
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptanceCollectionRequest agreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"), Optional.empty());
    }

    public SecurityEntityRequest security() {
        return new SecurityEntityRequest(contextPath.addSegment("security"), Optional.empty());
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"), Optional.empty());
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.empty());
    }

    public ManagedAppRegistrationRequest managedAppRegistrations(String id) {
        return new ManagedAppRegistrationRequest(contextPath.addSegment("managedAppRegistrations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppRegistrationCollectionRequest managedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"), Optional.empty());
    }

    public WindowsInformationProtectionDeviceRegistrationRequest windowsInformationProtectionDeviceRegistrations(String id) {
        return new WindowsInformationProtectionDeviceRegistrationRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsInformationProtectionDeviceRegistrationCollectionRequest windowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventRequest deviceManagementTroubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventCollectionRequest deviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("deviceManagementTroubleshootingEvents"), Optional.empty());
    }

    public MobileAppIntentAndStateRequest mobileAppIntentAndStates(String id) {
        return new MobileAppIntentAndStateRequest(contextPath.addSegment("mobileAppIntentAndStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppIntentAndStateCollectionRequest mobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(
                        contextPath.addSegment("mobileAppIntentAndStates"), Optional.empty());
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"), Optional.empty());
    }

    public NotificationRequest notifications(String id) {
        return new NotificationRequest(contextPath.addSegment("notifications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NotificationCollectionRequest notifications() {
        return new NotificationCollectionRequest(
                        contextPath.addSegment("notifications"), Optional.empty());
    }

    public PlannerUserRequest planner() {
        return new PlannerUserRequest(contextPath.addSegment("planner"), Optional.empty());
    }

    public ItemInsightsRequest insights() {
        return new ItemInsightsRequest(contextPath.addSegment("insights"), Optional.empty());
    }

    public UserSettingsRequest settings() {
        return new UserSettingsRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    public OnenoteRequest onenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"), Optional.empty());
    }

    public ProfilePhotoRequest photo() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.empty());
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"), Optional.empty());
    }

    public ProfileRequest profile() {
        return new ProfileRequest(contextPath.addSegment("profile"), Optional.empty());
    }

    public UserActivityRequest activities(String id) {
        return new UserActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserActivityCollectionRequest activities() {
        return new UserActivityCollectionRequest(
                        contextPath.addSegment("activities"), Optional.empty());
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCollectionRequest devices() {
        return new DeviceCollectionRequest(
                        contextPath.addSegment("devices"), Optional.empty());
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"), Optional.empty());
    }

    public PresenceRequest presence() {
        return new PresenceRequest(contextPath.addSegment("presence"), Optional.empty());
    }

    public AuthenticationRequest authentication() {
        return new AuthenticationRequest(contextPath.addSegment("authentication"), Optional.empty());
    }

    public TasksRequest tasks() {
        return new TasksRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatCollectionRequest chats() {
        return new ChatCollectionRequest(
                        contextPath.addSegment("chats"), Optional.empty());
    }

    public TeamRequest joinedTeams(String id) {
        return new TeamRequest(contextPath.addSegment("joinedTeams").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamCollectionRequest joinedTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("joinedTeams"), Optional.empty());
    }

    public UserTeamworkRequest teamwork() {
        return new UserTeamworkRequest(contextPath.addSegment("teamwork"), Optional.empty());
    }

    public TodoRequest todo() {
        return new TodoRequest(contextPath.addSegment("todo"), Optional.empty());
    }

    @Action(name = "activateServicePlan")
    @JsonIgnore
    public ActionRequestNoReturn activateServicePlan(UUID servicePlanId, UUID skuId) {
        Preconditions.checkNotNull(servicePlanId, "servicePlanId cannot be null");
        Preconditions.checkNotNull(skuId, "skuId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("servicePlanId", "Edm.Guid", servicePlanId)
            .put("skuId", "Edm.Guid", skuId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.activateServicePlan"), _parameters);
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> assignLicense(List<AssignedLicense> addLicenses, List<UUID> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), User.class, _parameters);
    }

    @Action(name = "changePassword")
    @JsonIgnore
    public ActionRequestNoReturn changePassword(String currentPassword, String newPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("currentPassword", "Edm.String", Checks.checkIsAscii(currentPassword))
            .put("newPassword", "Edm.String", Checks.checkIsAscii(newPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changePassword"), _parameters);
    }

    @Action(name = "invalidateAllRefreshTokens")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> invalidateAllRefreshTokens() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invalidateAllRefreshTokens"), Boolean.class, _parameters);
    }

    @Action(name = "reprocessLicenseAssignment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> reprocessLicenseAssignment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocessLicenseAssignment"), User.class, _parameters);
    }

    @Action(name = "revokeSignInSessions")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> revokeSignInSessions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeSignInSessions"), Boolean.class, _parameters);
    }

    @Action(name = "findMeetingTimes")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult> findMeetingTimes(List<AttendeeBase> attendees, LocationConstraint locationConstraint, TimeConstraint timeConstraint, Duration meetingDuration, Integer maxCandidates, Boolean isOrganizerOptional, Boolean returnSuggestionReasons, Double minimumAttendeePercentage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("attendees", "Collection(microsoft.graph.attendeeBase)", attendees)
            .put("locationConstraint", "microsoft.graph.locationConstraint", locationConstraint)
            .put("timeConstraint", "microsoft.graph.timeConstraint", timeConstraint)
            .put("meetingDuration", "Edm.Duration", meetingDuration)
            .put("maxCandidates", "Edm.Int32", maxCandidates)
            .put("isOrganizerOptional", "Edm.Boolean", isOrganizerOptional)
            .put("returnSuggestionReasons", "Edm.Boolean", returnSuggestionReasons)
            .put("minimumAttendeePercentage", "Edm.Double", minimumAttendeePercentage)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findMeetingTimes"), MeetingTimeSuggestionsResult.class, _parameters);
    }

    @Action(name = "getMailTips")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailTips> getMailTips(List<String> emailAddresses, MailTipsType mailTipsOptions) {
        Preconditions.checkNotNull(emailAddresses, "emailAddresses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EmailAddresses", "Collection(Edm.String)", Checks.checkIsAscii(emailAddresses))
            .put("MailTipsOptions", "microsoft.graph.mailTipsType", mailTipsOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailTips"), MailTips.class, _parameters);
    }

    @Action(name = "sendMail")
    @JsonIgnore
    public ActionRequestNoReturn sendMail(Message message, Boolean saveToSentItems) {
        Preconditions.checkNotNull(message, "message cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("SaveToSentItems", "Edm.Boolean", saveToSentItems)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendMail"), _parameters);
    }

    @Action(name = "translateExchangeIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ConvertIdResult> translateExchangeIds(List<String> inputIds, ExchangeIdFormat targetIdType, ExchangeIdFormat sourceIdType) {
        Preconditions.checkNotNull(inputIds, "inputIds cannot be null");
        Preconditions.checkNotNull(targetIdType, "targetIdType cannot be null");
        Preconditions.checkNotNull(sourceIdType, "sourceIdType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputIds", "Collection(Edm.String)", Checks.checkIsAscii(inputIds))
            .put("TargetIdType", "microsoft.graph.exchangeIdFormat", targetIdType)
            .put("SourceIdType", "microsoft.graph.exchangeIdFormat", sourceIdType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.translateExchangeIds"), ConvertIdResult.class, _parameters);
    }

    @Action(name = "removeAllDevicesFromManagement")
    @JsonIgnore
    public ActionRequestNoReturn removeAllDevicesFromManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeAllDevicesFromManagement"), _parameters);
    }

    @Action(name = "unblockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn unblockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unblockManagedApps"), _parameters);
    }

    @Action(name = "wipeAndBlockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn wipeAndBlockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeAndBlockManagedApps"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationByDeviceTag"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationsByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationsByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationsByDeviceTag"), _parameters);
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Function(name = "findRoomLists")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRoomLists() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRoomLists"), EmailAddress.class, _parameters);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms_Function(String roomList) {
        Preconditions.checkNotNull(roomList, "roomList cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoomList", "Edm.String", Checks.checkIsAscii(roomList))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters);
    }

    @Function(name = "reminderView")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Reminder> reminderView(String startDateTime, String endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("EndDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reminderView"), Reminder.class, _parameters);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData_Function(Integer skip, Integer top) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters);
    }

    @Function(name = "getEffectiveDeviceEnrollmentConfigurations")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceEnrollmentConfiguration> getEffectiveDeviceEnrollmentConfigurations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectiveDeviceEnrollmentConfigurations"), DeviceEnrollmentConfiguration.class, _parameters);
    }

    @Function(name = "getLoggedOnManagedDevices")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDevice> getLoggedOnManagedDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getLoggedOnManagedDevices"), ManagedDevice.class, _parameters);
    }

    @Function(name = "getManagedAppDiagnosticStatuses")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppDiagnosticStatus> getManagedAppDiagnosticStatuses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppDiagnosticStatuses"), ManagedAppDiagnosticStatus.class, _parameters);
    }

    @Function(name = "getManagedAppPolicies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppPolicy> getManagedAppPolicies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppPolicies"), ManagedAppPolicy.class, _parameters);
    }

    @Function(name = "isManagedAppUserBlocked")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isManagedAppUserBlocked() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isManagedAppUserBlocked"), Boolean.class, _parameters);
    }

    @Function(name = "getManagedDevicesWithAppFailures")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedDevicesWithAppFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithAppFailures"), String.class, _parameters);
    }

    @Function(name = "getManagedDevicesWithFailedOrPendingApps")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDeviceSummarizedAppState> getManagedDevicesWithFailedOrPendingApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithFailedOrPendingApps"), ManagedDeviceSummarizedAppState.class, _parameters);
    }

}
