package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserFlowLanguagePage;

@JsonIgnoreType
public class UserFlowLanguagePageRequest extends EntityRequest<UserFlowLanguagePage> {

    public UserFlowLanguagePageRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserFlowLanguagePage.class, contextPath, value, false);
    }

/**
 * If returning a stream without using object metadata is not supported then * returns {@code Optional.empty()}. Otherwise, returns a stream provider
 * where the location of the stream is assumed to be the current path + {@code /$value}.
 *
 * @return StreamProvider if suitable metadata found otherwise returns
 *         {@code Optional.empty()}
 */
@JsonIgnore
public Optional<StreamProvider> getStreamCurrentPath() {
    return RequestHelper.createStream(contextPath, null);
}

}
