package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserFlowLanguageConfiguration;
import odata.msgraph.client.beta.entity.collection.request.UserFlowLanguagePageCollectionRequest;

@JsonIgnoreType
public class UserFlowLanguageConfigurationRequest extends EntityRequest<UserFlowLanguageConfiguration> {

    public UserFlowLanguageConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserFlowLanguageConfiguration.class, contextPath, value, false);
    }

    public UserFlowLanguagePageRequest defaultPages(String id) {
        return new UserFlowLanguagePageRequest(contextPath.addSegment("defaultPages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguagePageCollectionRequest defaultPages() {
        return new UserFlowLanguagePageCollectionRequest(
                        contextPath.addSegment("defaultPages"), Optional.empty());
    }

    public UserFlowLanguagePageRequest overridesPages(String id) {
        return new UserFlowLanguagePageRequest(contextPath.addSegment("overridesPages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguagePageCollectionRequest overridesPages() {
        return new UserFlowLanguagePageCollectionRequest(
                        contextPath.addSegment("overridesPages"), Optional.empty());
    }

}
