package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsWorkFromAnywhereMetric;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest;

@JsonIgnoreType
public class UserExperienceAnalyticsWorkFromAnywhereMetricRequest extends EntityRequest<UserExperienceAnalyticsWorkFromAnywhereMetric> {

    public UserExperienceAnalyticsWorkFromAnywhereMetricRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserExperienceAnalyticsWorkFromAnywhereMetric.class, contextPath, value, false);
    }

    public UserExperienceAnalyticsWorkFromAnywhereDeviceRequest metricDevices(String id) {
        return new UserExperienceAnalyticsWorkFromAnywhereDeviceRequest(contextPath.addSegment("metricDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest metricDevices() {
        return new UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest(
                        contextPath.addSegment("metricDevices"), Optional.empty());
    }

}
