package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserAppInstallStatus;
import odata.msgraph.client.beta.entity.collection.request.MobileAppInstallStatusCollectionRequest;

@JsonIgnoreType
public class UserAppInstallStatusRequest extends EntityRequest<UserAppInstallStatus> {

    public UserAppInstallStatusRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserAppInstallStatus.class, contextPath, value, false);
    }

    public MobileAppRequest app() {
        return new MobileAppRequest(contextPath.addSegment("app"), Optional.empty());
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

}
