package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserActivity;
import odata.msgraph.client.beta.entity.collection.request.ActivityHistoryItemCollectionRequest;

@JsonIgnoreType
public class UserActivityRequest extends EntityRequest<UserActivity> {

    public UserActivityRequest(ContextPath contextPath, Optional<Object> value) {
        super(UserActivity.class, contextPath, value, false);
    }

    public ActivityHistoryItemRequest historyItems(String id) {
        return new ActivityHistoryItemRequest(contextPath.addSegment("historyItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ActivityHistoryItemCollectionRequest historyItems() {
        return new ActivityHistoryItemCollectionRequest(
                        contextPath.addSegment("historyItems"), Optional.empty());
    }

}
