package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleScheduleInstanceBase;

@JsonIgnoreType
public class UnifiedRoleScheduleInstanceBaseRequest extends EntityRequest<UnifiedRoleScheduleInstanceBase> {

    public UnifiedRoleScheduleInstanceBaseRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRoleScheduleInstanceBase.class, contextPath, value, false);
    }

    public AppScopeRequest appScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), Optional.empty());
    }

    public DirectoryObjectRequest directoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), Optional.empty());
    }

    public DirectoryObjectRequest principal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

}
