package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleManagementPolicy;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyRuleCollectionRequest;

@JsonIgnoreType
public class UnifiedRoleManagementPolicyRequest extends EntityRequest<UnifiedRoleManagementPolicy> {

    public UnifiedRoleManagementPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(UnifiedRoleManagementPolicy.class, contextPath, value, false);
    }

    public UnifiedRoleManagementPolicyRuleRequest effectiveRules(String id) {
        return new UnifiedRoleManagementPolicyRuleRequest(contextPath.addSegment("effectiveRules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleCollectionRequest effectiveRules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(
                        contextPath.addSegment("effectiveRules"), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleRequest rules(String id) {
        return new UnifiedRoleManagementPolicyRuleRequest(contextPath.addSegment("rules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRuleCollectionRequest rules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(
                        contextPath.addSegment("rules"), Optional.empty());
    }

}
