package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TrustFramework;
import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkKeySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrustFrameworkPolicyCollectionRequest;

@JsonIgnoreType
public class TrustFrameworkRequest extends EntityRequest<TrustFramework> {

    public TrustFrameworkRequest(ContextPath contextPath, Optional<Object> value) {
        super(TrustFramework.class, contextPath, value, false);
    }

    public TrustFrameworkKeySetRequest keySets(String id) {
        return new TrustFrameworkKeySetRequest(contextPath.addSegment("keySets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TrustFrameworkKeySetCollectionRequest keySets() {
        return new TrustFrameworkKeySetCollectionRequest(
                        contextPath.addSegment("keySets"), Optional.empty());
    }

    public TrustFrameworkPolicyRequest policies(String id) {
        return new TrustFrameworkPolicyRequest(contextPath.addSegment("policies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TrustFrameworkPolicyCollectionRequest policies() {
        return new TrustFrameworkPolicyCollectionRequest(
                        contextPath.addSegment("policies"), Optional.empty());
    }

}
