package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Todo;
import odata.msgraph.client.beta.entity.collection.request.TodoTaskListCollectionRequest;

@JsonIgnoreType
public class TodoRequest extends EntityRequest<Todo> {

    public TodoRequest(ContextPath contextPath, Optional<Object> value) {
        super(Todo.class, contextPath, value, false);
    }

    public TodoTaskListRequest lists(String id) {
        return new TodoTaskListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TodoTaskListCollectionRequest lists() {
        return new TodoTaskListCollectionRequest(
                        contextPath.addSegment("lists"), Optional.empty());
    }

}
