package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TermsOfUseContainer;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementCollectionRequest;

@JsonIgnoreType
public class TermsOfUseContainerRequest extends EntityRequest<TermsOfUseContainer> {

    public TermsOfUseContainerRequest(ContextPath contextPath, Optional<Object> value) {
        super(TermsOfUseContainer.class, contextPath, value, false);
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptanceCollectionRequest agreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"), Optional.empty());
    }

    public AgreementRequest agreements(String id) {
        return new AgreementRequest(contextPath.addSegment("agreements").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementCollectionRequest agreements() {
        return new AgreementCollectionRequest(
                        contextPath.addSegment("agreements"), Optional.empty());
    }

}
