package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Teamwork;
import odata.msgraph.client.beta.entity.collection.request.TeamworkDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkforceIntegrationCollectionRequest;

@JsonIgnoreType
public class TeamworkRequest extends EntityRequest<Teamwork> {

    public TeamworkRequest(ContextPath contextPath, Optional<Object> value) {
        super(Teamwork.class, contextPath, value, false);
    }

    public WorkforceIntegrationRequest workforceIntegrations(String id) {
        return new WorkforceIntegrationRequest(contextPath.addSegment("workforceIntegrations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkforceIntegrationCollectionRequest workforceIntegrations() {
        return new WorkforceIntegrationCollectionRequest(
                        contextPath.addSegment("workforceIntegrations"), Optional.empty());
    }

    public TeamworkDeviceRequest devices(String id) {
        return new TeamworkDeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamworkDeviceCollectionRequest devices() {
        return new TeamworkDeviceCollectionRequest(
                        contextPath.addSegment("devices"), Optional.empty());
    }

}
