package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamsApp;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppDefinitionCollectionRequest;

@JsonIgnoreType
public class TeamsAppRequest extends EntityRequest<TeamsApp> {

    public TeamsAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(TeamsApp.class, contextPath, value, false);
    }

    public TeamsAppDefinitionRequest appDefinitions(String id) {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("appDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppDefinitionCollectionRequest appDefinitions() {
        return new TeamsAppDefinitionCollectionRequest(
                        contextPath.addSegment("appDefinitions"), Optional.empty());
    }

}
