package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TeamsAppDefinition;

@JsonIgnoreType
public class TeamsAppDefinitionRequest extends EntityRequest<TeamsAppDefinition> {

    public TeamsAppDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(TeamsAppDefinition.class, contextPath, value, false);
    }

    public TeamworkBotRequest bot() {
        return new TeamworkBotRequest(contextPath.addSegment("bot"), Optional.empty());
    }

    public TeamsAppIconRequest colorIcon() {
        return new TeamsAppIconRequest(contextPath.addSegment("colorIcon"), Optional.empty());
    }

    public TeamsAppIconRequest outlineIcon() {
        return new TeamsAppIconRequest(contextPath.addSegment("outlineIcon"), Optional.empty());
    }

}
