package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AttributeDefinition;
import odata.msgraph.client.beta.complex.ExpressionInputObject;
import odata.msgraph.client.beta.complex.ParseExpressionResponse;
import odata.msgraph.client.beta.entity.AttributeMappingFunctionSchema;
import odata.msgraph.client.beta.entity.FilterOperatorSchema;
import odata.msgraph.client.beta.entity.SynchronizationSchema;
import odata.msgraph.client.beta.entity.collection.request.DirectoryDefinitionCollectionRequest;

@JsonIgnoreType
public class SynchronizationSchemaRequest extends EntityRequest<SynchronizationSchema> {

    public SynchronizationSchemaRequest(ContextPath contextPath, Optional<Object> value) {
        super(SynchronizationSchema.class, contextPath, value, false);
    }

    public DirectoryDefinitionRequest directories(String id) {
        return new DirectoryDefinitionRequest(contextPath.addSegment("directories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryDefinitionCollectionRequest directories() {
        return new DirectoryDefinitionCollectionRequest(
                        contextPath.addSegment("directories"), Optional.empty());
    }

    @Action(name = "parseExpression")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse> parseExpression(String expression, ExpressionInputObject testInputObject, AttributeDefinition targetAttributeDefinition) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("expression", "Edm.String", Checks.checkIsAscii(expression))
            .put("testInputObject", "microsoft.graph.expressionInputObject", testInputObject)
            .put("targetAttributeDefinition", "microsoft.graph.attributeDefinition", targetAttributeDefinition)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.parseExpression"), ParseExpressionResponse.class, _parameters);
    }

    @Function(name = "filterOperators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FilterOperatorSchema> filterOperators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterOperators"), FilterOperatorSchema.class, _parameters);
    }

    @Function(name = "functions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttributeMappingFunctionSchema> functions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.functions"), AttributeMappingFunctionSchema.class, _parameters);
    }

}
