package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.entity.Synchronization;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationTemplateCollectionRequest;

@JsonIgnoreType
public class SynchronizationRequest extends EntityRequest<Synchronization> {

    public SynchronizationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Synchronization.class, contextPath, value, false);
    }

    public SynchronizationJobRequest jobs(String id) {
        return new SynchronizationJobRequest(contextPath.addSegment("jobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SynchronizationJobCollectionRequest jobs() {
        return new SynchronizationJobCollectionRequest(
                        contextPath.addSegment("jobs"), Optional.empty());
    }

    public SynchronizationTemplateRequest templates(String id) {
        return new SynchronizationTemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SynchronizationTemplateCollectionRequest templates() {
        return new SynchronizationTemplateCollectionRequest(
                        contextPath.addSegment("templates"), Optional.empty());
    }

    @Action(name = "acquireAccessToken")
    @JsonIgnore
    public ActionRequestNoReturn acquireAccessToken(List<SynchronizationSecretKeyStringValuePair> credentials) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("credentials", "Collection(microsoft.graph.synchronizationSecretKeyStringValuePair)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acquireAccessToken"), _parameters);
    }

    @Function(name = "Ping")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> ping() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Ping"), String.class, _parameters);
    }

}
