package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SmsAuthenticationMethodConfiguration;
import odata.msgraph.client.beta.entity.collection.request.SmsAuthenticationMethodTargetCollectionRequest;

@JsonIgnoreType
public class SmsAuthenticationMethodConfigurationRequest extends EntityRequest<SmsAuthenticationMethodConfiguration> {

    public SmsAuthenticationMethodConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(SmsAuthenticationMethodConfiguration.class, contextPath, value, false);
    }

    public SmsAuthenticationMethodTargetRequest includeTargets(String id) {
        return new SmsAuthenticationMethodTargetRequest(contextPath.addSegment("includeTargets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SmsAuthenticationMethodTargetCollectionRequest includeTargets() {
        return new SmsAuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.empty());
    }

}
