package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ContentType;
import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.Site;
import odata.msgraph.client.beta.entity.collection.request.BaseItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RichLongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SitePageCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.request.StoreRequest;

@JsonIgnoreType
public class SiteRequest extends EntityRequest<Site> {

    public SiteRequest(ContextPath contextPath, Optional<Object> value) {
        super(Site.class, contextPath, value, false);
    }

    public ItemAnalyticsRequest analytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"), Optional.empty());
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.empty());
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"), Optional.empty());
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.empty());
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"), Optional.empty());
    }

    public ColumnDefinitionRequest externalColumns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("externalColumns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest externalColumns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("externalColumns"), Optional.empty());
    }

    public BaseItemRequest items(String id) {
        return new BaseItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseItemCollectionRequest items() {
        return new BaseItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public ListRequest lists(String id) {
        return new ListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListCollectionRequest lists() {
        return new ListCollectionRequest(
                        contextPath.addSegment("lists"), Optional.empty());
    }

    public RichLongRunningOperationRequest operations(String id) {
        return new RichLongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RichLongRunningOperationCollectionRequest operations() {
        return new RichLongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public SitePageRequest pages(String id) {
        return new SitePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SitePageCollectionRequest pages() {
        return new SitePageCollectionRequest(
                        contextPath.addSegment("pages"), Optional.empty());
    }

    public PermissionRequest permissions(String id) {
        return new PermissionRequest(contextPath.addSegment("permissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionCollectionRequest permissions() {
        return new PermissionCollectionRequest(
                        contextPath.addSegment("permissions"), Optional.empty());
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("sites"), Optional.empty());
    }

    public StoreRequest termStore() {
        return new StoreRequest(contextPath.addSegment("termStore"), Optional.empty());
    }

    public OnenoteRequest onenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"), Optional.empty());
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters);
    }

    @Function(name = "getApplicableContentTypesForList")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ContentType> getApplicableContentTypesForList(String listId) {
        Preconditions.checkNotNull(listId, "listId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("listId", "Edm.String", Checks.checkIsAscii(listId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getApplicableContentTypesForList"), ContentType.class, _parameters);
    }

    @Function(name = "getByPath")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Site> getByPath(String path) {
        Preconditions.checkNotNull(path, "path cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("path", "Edm.String", Checks.checkIsAscii(path))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Site>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getByPath"), Site.class, _parameters);
    }

}
