package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceUpdateMessage;
import odata.msgraph.client.beta.entity.collection.request.ServiceAnnouncementAttachmentCollectionRequest;

@JsonIgnoreType
public class ServiceUpdateMessageRequest extends EntityRequest<ServiceUpdateMessage> {

    public ServiceUpdateMessageRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServiceUpdateMessage.class, contextPath, value, true);
    }

    public ServiceAnnouncementAttachmentRequest attachments(String id) {
        return new ServiceAnnouncementAttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceAnnouncementAttachmentCollectionRequest attachments() {
        return new ServiceAnnouncementAttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.empty());
    }

}
