package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceHealth;
import odata.msgraph.client.beta.entity.collection.request.ServiceHealthIssueCollectionRequest;

@JsonIgnoreType
public class ServiceHealthRequest extends EntityRequest<ServiceHealth> {

    public ServiceHealthRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServiceHealth.class, contextPath, value, false);
    }

    public ServiceHealthIssueRequest issues(String id) {
        return new ServiceHealthIssueRequest(contextPath.addSegment("issues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceHealthIssueCollectionRequest issues() {
        return new ServiceHealthIssueCollectionRequest(
                        contextPath.addSegment("issues"), Optional.empty());
    }

}
