package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceHealthIssue;

@JsonIgnoreType
public class ServiceHealthIssueRequest extends EntityRequest<ServiceHealthIssue> {

    public ServiceHealthIssueRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServiceHealthIssue.class, contextPath, value, false);
    }

    @Function(name = "incidentReport")
    @JsonIgnore
    public FunctionRequestReturningStream incidentReport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.incidentReport"), _parameters);
    }

}
