package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceAnnouncement;
import odata.msgraph.client.beta.entity.collection.request.ServiceHealthCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServiceHealthIssueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServiceUpdateMessageCollectionRequest;

@JsonIgnoreType
public class ServiceAnnouncementRequest extends EntityRequest<ServiceAnnouncement> {

    public ServiceAnnouncementRequest(ContextPath contextPath, Optional<Object> value) {
        super(ServiceAnnouncement.class, contextPath, value, false);
    }

    public ServiceHealthRequest healthOverviews(String id) {
        return new ServiceHealthRequest(contextPath.addSegment("healthOverviews").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceHealthCollectionRequest healthOverviews() {
        return new ServiceHealthCollectionRequest(
                        contextPath.addSegment("healthOverviews"), Optional.empty());
    }

    public ServiceHealthIssueRequest issues(String id) {
        return new ServiceHealthIssueRequest(contextPath.addSegment("issues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceHealthIssueCollectionRequest issues() {
        return new ServiceHealthIssueCollectionRequest(
                        contextPath.addSegment("issues"), Optional.empty());
    }

    public ServiceUpdateMessageRequest messages(String id) {
        return new ServiceUpdateMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceUpdateMessageCollectionRequest messages() {
        return new ServiceUpdateMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.empty());
    }

}
