package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.security.entity.request.InformationProtectionEntityRequest;

import odata.msgraph.client.beta.entity.Security;
import odata.msgraph.client.beta.entity.collection.request.AlertCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudAppSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FileSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HostSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IpSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProviderTenantSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreControlProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityActionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TiIndicatorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserSecurityProfileCollectionRequest;

@JsonIgnoreType
public class SecurityRequest extends EntityRequest<Security> {

    public SecurityRequest(ContextPath contextPath, Optional<Object> value) {
        super(Security.class, contextPath, value, false);
    }

    public InformationProtectionEntityRequest informationProtection() {
        return new InformationProtectionEntityRequest(contextPath.addSegment("informationProtection"), Optional.empty());
    }

    public AttackSimulationRootRequest attackSimulation() {
        return new AttackSimulationRootRequest(contextPath.addSegment("attackSimulation"), Optional.empty());
    }

    public AlertRequest alerts(String id) {
        return new AlertRequest(contextPath.addSegment("alerts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AlertCollectionRequest alerts() {
        return new AlertCollectionRequest(
                        contextPath.addSegment("alerts"), Optional.empty());
    }

    public CloudAppSecurityProfileRequest cloudAppSecurityProfiles(String id) {
        return new CloudAppSecurityProfileRequest(contextPath.addSegment("cloudAppSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudAppSecurityProfileCollectionRequest cloudAppSecurityProfiles() {
        return new CloudAppSecurityProfileCollectionRequest(
                        contextPath.addSegment("cloudAppSecurityProfiles"), Optional.empty());
    }

    public DomainSecurityProfileRequest domainSecurityProfiles(String id) {
        return new DomainSecurityProfileRequest(contextPath.addSegment("domainSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainSecurityProfileCollectionRequest domainSecurityProfiles() {
        return new DomainSecurityProfileCollectionRequest(
                        contextPath.addSegment("domainSecurityProfiles"), Optional.empty());
    }

    public FileSecurityProfileRequest fileSecurityProfiles(String id) {
        return new FileSecurityProfileRequest(contextPath.addSegment("fileSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FileSecurityProfileCollectionRequest fileSecurityProfiles() {
        return new FileSecurityProfileCollectionRequest(
                        contextPath.addSegment("fileSecurityProfiles"), Optional.empty());
    }

    public HostSecurityProfileRequest hostSecurityProfiles(String id) {
        return new HostSecurityProfileRequest(contextPath.addSegment("hostSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HostSecurityProfileCollectionRequest hostSecurityProfiles() {
        return new HostSecurityProfileCollectionRequest(
                        contextPath.addSegment("hostSecurityProfiles"), Optional.empty());
    }

    public IpSecurityProfileRequest ipSecurityProfiles(String id) {
        return new IpSecurityProfileRequest(contextPath.addSegment("ipSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IpSecurityProfileCollectionRequest ipSecurityProfiles() {
        return new IpSecurityProfileCollectionRequest(
                        contextPath.addSegment("ipSecurityProfiles"), Optional.empty());
    }

    public ProviderTenantSettingRequest providerTenantSettings(String id) {
        return new ProviderTenantSettingRequest(contextPath.addSegment("providerTenantSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProviderTenantSettingCollectionRequest providerTenantSettings() {
        return new ProviderTenantSettingCollectionRequest(
                        contextPath.addSegment("providerTenantSettings"), Optional.empty());
    }

    public SecureScoreControlProfileRequest secureScoreControlProfiles(String id) {
        return new SecureScoreControlProfileRequest(contextPath.addSegment("secureScoreControlProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecureScoreControlProfileCollectionRequest secureScoreControlProfiles() {
        return new SecureScoreControlProfileCollectionRequest(
                        contextPath.addSegment("secureScoreControlProfiles"), Optional.empty());
    }

    public SecureScoreRequest secureScores(String id) {
        return new SecureScoreRequest(contextPath.addSegment("secureScores").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecureScoreCollectionRequest secureScores() {
        return new SecureScoreCollectionRequest(
                        contextPath.addSegment("secureScores"), Optional.empty());
    }

    public SecurityActionRequest securityActions(String id) {
        return new SecurityActionRequest(contextPath.addSegment("securityActions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityActionCollectionRequest securityActions() {
        return new SecurityActionCollectionRequest(
                        contextPath.addSegment("securityActions"), Optional.empty());
    }

    public TiIndicatorRequest tiIndicators(String id) {
        return new TiIndicatorRequest(contextPath.addSegment("tiIndicators").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TiIndicatorCollectionRequest tiIndicators() {
        return new TiIndicatorCollectionRequest(
                        contextPath.addSegment("tiIndicators"), Optional.empty());
    }

    public UserSecurityProfileRequest userSecurityProfiles(String id) {
        return new UserSecurityProfileRequest(contextPath.addSegment("userSecurityProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserSecurityProfileCollectionRequest userSecurityProfiles() {
        return new UserSecurityProfileCollectionRequest(
                        contextPath.addSegment("userSecurityProfiles"), Optional.empty());
    }

}
