package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SectionGroup;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;

@JsonIgnoreType
public class SectionGroupRequest extends EntityRequest<SectionGroup> {

    public SectionGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(SectionGroup.class, contextPath, value, false);
    }

    public NotebookRequest parentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"), Optional.empty());
    }

    public SectionGroupRequest parentSectionGroup() {
        return new SectionGroupRequest(contextPath.addSegment("parentSectionGroup"), Optional.empty());
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"), Optional.empty());
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"), Optional.empty());
    }

}
