package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SamlOrWsFedExternalDomainFederation;
import odata.msgraph.client.beta.entity.collection.request.ExternalDomainNameCollectionRequest;

@JsonIgnoreType
public class SamlOrWsFedExternalDomainFederationRequest extends EntityRequest<SamlOrWsFedExternalDomainFederation> {

    public SamlOrWsFedExternalDomainFederationRequest(ContextPath contextPath, Optional<Object> value) {
        super(SamlOrWsFedExternalDomainFederation.class, contextPath, value, false);
    }

    public ExternalDomainNameRequest domains(String id) {
        return new ExternalDomainNameRequest(contextPath.addSegment("domains").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalDomainNameCollectionRequest domains() {
        return new ExternalDomainNameCollectionRequest(
                        contextPath.addSegment("domains"), Optional.empty());
    }

}
