package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RiskyUser;
import odata.msgraph.client.beta.entity.collection.request.RiskyUserHistoryItemCollectionRequest;

@JsonIgnoreType
public class RiskyUserRequest extends EntityRequest<RiskyUser> {

    public RiskyUserRequest(ContextPath contextPath, Optional<Object> value) {
        super(RiskyUser.class, contextPath, value, false);
    }

    public RiskyUserHistoryItemRequest history(String id) {
        return new RiskyUserHistoryItemRequest(contextPath.addSegment("history").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyUserHistoryItemCollectionRequest history() {
        return new RiskyUserHistoryItemCollectionRequest(
                        contextPath.addSegment("history"), Optional.empty());
    }

}
