package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Recommendation;
import odata.msgraph.client.beta.entity.collection.request.RecommendationResourceCollectionRequest;

@JsonIgnoreType
public class RecommendationRequest extends EntityRequest<Recommendation> {

    public RecommendationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Recommendation.class, contextPath, value, false);
    }

    public RecommendationResourceRequest impactedResources(String id) {
        return new RecommendationResourceRequest(contextPath.addSegment("impactedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RecommendationResourceCollectionRequest impactedResources() {
        return new RecommendationResourceCollectionRequest(
                        contextPath.addSegment("impactedResources"), Optional.empty());
    }

    @Action(name = "complete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> complete() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complete"), Recommendation.class, _parameters);
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> dismiss(String dismissReason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("dismissReason", "Edm.String", Checks.checkIsAscii(dismissReason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), Recommendation.class, _parameters);
    }

    @Action(name = "postpone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> postpone(OffsetDateTime postponeUntilDateTime) {
        Preconditions.checkNotNull(postponeUntilDateTime, "postponeUntilDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("postponeUntilDateTime", "Edm.DateTimeOffset", postponeUntilDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postpone"), Recommendation.class, _parameters);
    }

    @Action(name = "reactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recommendation> reactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Recommendation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reactivate"), Recommendation.class, _parameters);
    }

}
