package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RbacApplication;
import odata.msgraph.client.beta.entity.UnifiedRoleScheduleBase;
import odata.msgraph.client.beta.entity.UnifiedRoleScheduleInstanceBase;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceNamespaceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentScheduleRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleEligibilityScheduleRequestCollectionRequest;

@JsonIgnoreType
public class RbacApplicationRequest extends EntityRequest<RbacApplication> {

    public RbacApplicationRequest(ContextPath contextPath, Optional<Object> value) {
        super(RbacApplication.class, contextPath, value, false);
    }

    public UnifiedRbacResourceNamespaceRequest resourceNamespaces(String id) {
        return new UnifiedRbacResourceNamespaceRequest(contextPath.addSegment("resourceNamespaces").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRbacResourceNamespaceCollectionRequest resourceNamespaces() {
        return new UnifiedRbacResourceNamespaceCollectionRequest(
                        contextPath.addSegment("resourceNamespaces"), Optional.empty());
    }

    public UnifiedRoleAssignmentRequest roleAssignments(String id) {
        return new UnifiedRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentCollectionRequest roleAssignments() {
        return new UnifiedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinitions(String id) {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleDefinitionCollectionRequest roleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.empty());
    }

    public UnifiedRoleAssignmentRequest transitiveRoleAssignments(String id) {
        return new UnifiedRoleAssignmentRequest(contextPath.addSegment("transitiveRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentCollectionRequest transitiveRoleAssignments() {
        return new UnifiedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("transitiveRoleAssignments"), Optional.empty());
    }

    public ApprovalRequest roleAssignmentApprovals(String id) {
        return new ApprovalRequest(contextPath.addSegment("roleAssignmentApprovals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalCollectionRequest roleAssignmentApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("roleAssignmentApprovals"), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleInstanceRequest roleAssignmentScheduleInstances(String id) {
        return new UnifiedRoleAssignmentScheduleInstanceRequest(contextPath.addSegment("roleAssignmentScheduleInstances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest roleAssignmentScheduleInstances() {
        return new UnifiedRoleAssignmentScheduleInstanceCollectionRequest(
                        contextPath.addSegment("roleAssignmentScheduleInstances"), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleRequestRequest roleAssignmentScheduleRequests(String id) {
        return new UnifiedRoleAssignmentScheduleRequestRequest(contextPath.addSegment("roleAssignmentScheduleRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleRequestCollectionRequest roleAssignmentScheduleRequests() {
        return new UnifiedRoleAssignmentScheduleRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentScheduleRequests"), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleRequest roleAssignmentSchedules(String id) {
        return new UnifiedRoleAssignmentScheduleRequest(contextPath.addSegment("roleAssignmentSchedules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentScheduleCollectionRequest roleAssignmentSchedules() {
        return new UnifiedRoleAssignmentScheduleCollectionRequest(
                        contextPath.addSegment("roleAssignmentSchedules"), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleInstanceRequest roleEligibilityScheduleInstances(String id) {
        return new UnifiedRoleEligibilityScheduleInstanceRequest(contextPath.addSegment("roleEligibilityScheduleInstances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleInstanceCollectionRequest roleEligibilityScheduleInstances() {
        return new UnifiedRoleEligibilityScheduleInstanceCollectionRequest(
                        contextPath.addSegment("roleEligibilityScheduleInstances"), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleRequestRequest roleEligibilityScheduleRequests(String id) {
        return new UnifiedRoleEligibilityScheduleRequestRequest(contextPath.addSegment("roleEligibilityScheduleRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleRequestCollectionRequest roleEligibilityScheduleRequests() {
        return new UnifiedRoleEligibilityScheduleRequestCollectionRequest(
                        contextPath.addSegment("roleEligibilityScheduleRequests"), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleRequest roleEligibilitySchedules(String id) {
        return new UnifiedRoleEligibilityScheduleRequest(contextPath.addSegment("roleEligibilitySchedules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleEligibilityScheduleCollectionRequest roleEligibilitySchedules() {
        return new UnifiedRoleEligibilityScheduleCollectionRequest(
                        contextPath.addSegment("roleEligibilitySchedules"), Optional.empty());
    }

    @Function(name = "roleScheduleInstances")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleScheduleInstanceBase> roleScheduleInstances(String directoryScopeId, String appScopeId, String principalId, String roleDefinitionId) {
        Preconditions.checkNotNull(directoryScopeId, "directoryScopeId cannot be null");
        Preconditions.checkNotNull(appScopeId, "appScopeId cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Preconditions.checkNotNull(roleDefinitionId, "roleDefinitionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("directoryScopeId", "Edm.String", Checks.checkIsAscii(directoryScopeId))
            .put("appScopeId", "Edm.String", Checks.checkIsAscii(appScopeId))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("roleDefinitionId", "Edm.String", Checks.checkIsAscii(roleDefinitionId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roleScheduleInstances"), UnifiedRoleScheduleInstanceBase.class, _parameters);
    }

    @Function(name = "roleSchedules")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleScheduleBase> roleSchedules(String directoryScopeId, String appScopeId, String principalId, String roleDefinitionId) {
        Preconditions.checkNotNull(directoryScopeId, "directoryScopeId cannot be null");
        Preconditions.checkNotNull(appScopeId, "appScopeId cannot be null");
        Preconditions.checkNotNull(principalId, "principalId cannot be null");
        Preconditions.checkNotNull(roleDefinitionId, "roleDefinitionId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("directoryScopeId", "Edm.String", Checks.checkIsAscii(directoryScopeId))
            .put("appScopeId", "Edm.String", Checks.checkIsAscii(appScopeId))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("roleDefinitionId", "Edm.String", Checks.checkIsAscii(roleDefinitionId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.roleSchedules"), UnifiedRoleScheduleBase.class, _parameters);
    }

}
