package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RbacApplicationMultiple;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRbacResourceNamespaceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentMultipleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;

@JsonIgnoreType
public class RbacApplicationMultipleRequest extends EntityRequest<RbacApplicationMultiple> {

    public RbacApplicationMultipleRequest(ContextPath contextPath, Optional<Object> value) {
        super(RbacApplicationMultiple.class, contextPath, value, false);
    }

    public UnifiedRbacResourceNamespaceRequest resourceNamespaces(String id) {
        return new UnifiedRbacResourceNamespaceRequest(contextPath.addSegment("resourceNamespaces").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRbacResourceNamespaceCollectionRequest resourceNamespaces() {
        return new UnifiedRbacResourceNamespaceCollectionRequest(
                        contextPath.addSegment("resourceNamespaces"), Optional.empty());
    }

    public UnifiedRoleAssignmentMultipleRequest roleAssignments(String id) {
        return new UnifiedRoleAssignmentMultipleRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleAssignmentMultipleCollectionRequest roleAssignments() {
        return new UnifiedRoleAssignmentMultipleCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.empty());
    }

    public UnifiedRoleDefinitionRequest roleDefinitions(String id) {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleDefinitionCollectionRequest roleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.empty());
    }

}
