package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrivilegedApproval;

@JsonIgnoreType
public class PrivilegedApprovalRequest extends EntityRequest<PrivilegedApproval> {

    public PrivilegedApprovalRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrivilegedApproval.class, contextPath, value, false);
    }

    public PrivilegedRoleAssignmentRequestRequest request() {
        return new PrivilegedRoleAssignmentRequestRequest(contextPath.addSegment("request"), Optional.empty());
    }

    public PrivilegedRoleRequest roleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"), Optional.empty());
    }

}
