package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Privacy;
import odata.msgraph.client.beta.entity.collection.request.SubjectRightsRequestCollectionRequest;

@JsonIgnoreType
public class PrivacyRequest extends EntityRequest<Privacy> {

    public PrivacyRequest(ContextPath contextPath, Optional<Object> value) {
        super(Privacy.class, contextPath, value, false);
    }

    public SubjectRightsRequestRequest subjectRightsRequests(String id) {
        return new SubjectRightsRequestRequest(contextPath.addSegment("subjectRightsRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SubjectRightsRequestCollectionRequest subjectRightsRequests() {
        return new SubjectRightsRequestCollectionRequest(
                        contextPath.addSegment("subjectRightsRequests"), Optional.empty());
    }

}
