package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.entity.Printer;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskTriggerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;

@JsonIgnoreType
public class PrinterRequest extends EntityRequest<Printer> {

    public PrinterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Printer.class, contextPath, value, false);
    }

    public PrintConnectorRequest connectors(String id) {
        return new PrintConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintConnectorCollectionRequest connectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), Optional.empty());
    }

    public PrinterShareRequest share() {
        return new PrinterShareRequest(contextPath.addSegment("share"), Optional.empty());
    }

    public PrinterShareRequest shares(String id) {
        return new PrinterShareRequest(contextPath.addSegment("shares").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrinterShareCollectionRequest shares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"), Optional.empty());
    }

    public PrintTaskTriggerRequest taskTriggers(String id) {
        return new PrintTaskTriggerRequest(contextPath.addSegment("taskTriggers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskTriggerCollectionRequest taskTriggers() {
        return new PrintTaskTriggerCollectionRequest(
                        contextPath.addSegment("taskTriggers"), Optional.empty());
    }

    @Action(name = "resetDefaults")
    @JsonIgnore
    public ActionRequestNoReturn resetDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDefaults"), _parameters);
    }

    @Action(name = "restoreFactoryDefaults")
    @JsonIgnore
    public ActionRequestNoReturn restoreFactoryDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restoreFactoryDefaults"), _parameters);
    }

    @Function(name = "getCapabilities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities> getCapabilities() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCapabilities"), PrinterCapabilities.class, _parameters);
    }

}
