package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintDocumentUploadProperties;
import odata.msgraph.client.beta.complex.UploadSession;
import odata.msgraph.client.beta.entity.PrintDocument;

@JsonIgnoreType
public class PrintDocumentRequest extends EntityRequest<PrintDocument> {

    public PrintDocumentRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrintDocument.class, contextPath, value, false);
    }

/**
 * If returning a stream without using object metadata is not supported then * returns {@code Optional.empty()}. Otherwise, returns a stream provider
 * where the location of the stream is assumed to be the current path + {@code /$value}.
 *
 * @return StreamProvider if suitable metadata found otherwise returns
 *         {@code Optional.empty()}
 */
@JsonIgnore
public Optional<StreamProvider> getStreamCurrentPath() {
    return RequestHelper.createStream(contextPath, null);
}

    @Action(name = "createUploadSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UploadSession> createUploadSession(PrintDocumentUploadProperties properties) {
        Preconditions.checkNotNull(properties, "properties cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("properties", "microsoft.graph.printDocumentUploadProperties", properties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UploadSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createUploadSession"), UploadSession.class, _parameters);
    }

}
