package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PolicyRoot;
import odata.msgraph.client.beta.entity.collection.request.ActivityBasedTimeoutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuthorizationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FeatureRolloutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobilityManagementPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionGrantPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalCreationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyCollectionRequest;

@JsonIgnoreType
public class PolicyRootRequest extends EntityRequest<PolicyRoot> {

    public PolicyRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(PolicyRoot.class, contextPath, value, false);
    }

    public AuthenticationMethodsPolicyRequest authenticationMethodsPolicy() {
        return new AuthenticationMethodsPolicyRequest(contextPath.addSegment("authenticationMethodsPolicy"), Optional.empty());
    }

    public AuthenticationFlowsPolicyRequest authenticationFlowsPolicy() {
        return new AuthenticationFlowsPolicyRequest(contextPath.addSegment("authenticationFlowsPolicy"), Optional.empty());
    }

    public B2cAuthenticationMethodsPolicyRequest b2cAuthenticationMethodsPolicy() {
        return new B2cAuthenticationMethodsPolicyRequest(contextPath.addSegment("b2cAuthenticationMethodsPolicy"), Optional.empty());
    }

    public ActivityBasedTimeoutPolicyRequest activityBasedTimeoutPolicies(String id) {
        return new ActivityBasedTimeoutPolicyRequest(contextPath.addSegment("activityBasedTimeoutPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ActivityBasedTimeoutPolicyCollectionRequest activityBasedTimeoutPolicies() {
        return new ActivityBasedTimeoutPolicyCollectionRequest(
                        contextPath.addSegment("activityBasedTimeoutPolicies"), Optional.empty());
    }

    public AppManagementPolicyRequest appManagementPolicies(String id) {
        return new AppManagementPolicyRequest(contextPath.addSegment("appManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppManagementPolicyCollectionRequest appManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(
                        contextPath.addSegment("appManagementPolicies"), Optional.empty());
    }

    public AuthorizationPolicyRequest authorizationPolicy(String id) {
        return new AuthorizationPolicyRequest(contextPath.addSegment("authorizationPolicy").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthorizationPolicyCollectionRequest authorizationPolicy() {
        return new AuthorizationPolicyCollectionRequest(
                        contextPath.addSegment("authorizationPolicy"), Optional.empty());
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"), Optional.empty());
    }

    public CrossTenantAccessPolicyRequest crossTenantAccessPolicy() {
        return new CrossTenantAccessPolicyRequest(contextPath.addSegment("crossTenantAccessPolicy"), Optional.empty());
    }

    public TenantAppManagementPolicyRequest defaultAppManagementPolicy() {
        return new TenantAppManagementPolicyRequest(contextPath.addSegment("defaultAppManagementPolicy"), Optional.empty());
    }

    public ExternalIdentitiesPolicyRequest externalIdentitiesPolicy() {
        return new ExternalIdentitiesPolicyRequest(contextPath.addSegment("externalIdentitiesPolicy"), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.empty());
    }

    public PermissionGrantPolicyRequest permissionGrantPolicies(String id) {
        return new PermissionGrantPolicyRequest(contextPath.addSegment("permissionGrantPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrantPolicyCollectionRequest permissionGrantPolicies() {
        return new PermissionGrantPolicyCollectionRequest(
                        contextPath.addSegment("permissionGrantPolicies"), Optional.empty());
    }

    public ServicePrincipalCreationPolicyRequest servicePrincipalCreationPolicies(String id) {
        return new ServicePrincipalCreationPolicyRequest(contextPath.addSegment("servicePrincipalCreationPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalCreationPolicyCollectionRequest servicePrincipalCreationPolicies() {
        return new ServicePrincipalCreationPolicyCollectionRequest(
                        contextPath.addSegment("servicePrincipalCreationPolicies"), Optional.empty());
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"), Optional.empty());
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"), Optional.empty());
    }

    public FeatureRolloutPolicyRequest featureRolloutPolicies(String id) {
        return new FeatureRolloutPolicyRequest(contextPath.addSegment("featureRolloutPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FeatureRolloutPolicyCollectionRequest featureRolloutPolicies() {
        return new FeatureRolloutPolicyCollectionRequest(
                        contextPath.addSegment("featureRolloutPolicies"), Optional.empty());
    }

    public AccessReviewPolicyRequest accessReviewPolicy() {
        return new AccessReviewPolicyRequest(contextPath.addSegment("accessReviewPolicy"), Optional.empty());
    }

    public AdminConsentRequestPolicyRequest adminConsentRequestPolicy() {
        return new AdminConsentRequestPolicyRequest(contextPath.addSegment("adminConsentRequestPolicy"), Optional.empty());
    }

    public DirectoryRoleAccessReviewPolicyRequest directoryRoleAccessReviewPolicy() {
        return new DirectoryRoleAccessReviewPolicyRequest(contextPath.addSegment("directoryRoleAccessReviewPolicy"), Optional.empty());
    }

    public ConditionalAccessPolicyRequest conditionalAccessPolicies(String id) {
        return new ConditionalAccessPolicyRequest(contextPath.addSegment("conditionalAccessPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConditionalAccessPolicyCollectionRequest conditionalAccessPolicies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicies"), Optional.empty());
    }

    public IdentitySecurityDefaultsEnforcementPolicyRequest identitySecurityDefaultsEnforcementPolicy() {
        return new IdentitySecurityDefaultsEnforcementPolicyRequest(contextPath.addSegment("identitySecurityDefaultsEnforcementPolicy"), Optional.empty());
    }

    public MobilityManagementPolicyRequest mobileAppManagementPolicies(String id) {
        return new MobilityManagementPolicyRequest(contextPath.addSegment("mobileAppManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobilityManagementPolicyCollectionRequest mobileAppManagementPolicies() {
        return new MobilityManagementPolicyCollectionRequest(
                        contextPath.addSegment("mobileAppManagementPolicies"), Optional.empty());
    }

    public MobilityManagementPolicyRequest mobileDeviceManagementPolicies(String id) {
        return new MobilityManagementPolicyRequest(contextPath.addSegment("mobileDeviceManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobilityManagementPolicyCollectionRequest mobileDeviceManagementPolicies() {
        return new MobilityManagementPolicyCollectionRequest(
                        contextPath.addSegment("mobileDeviceManagementPolicies"), Optional.empty());
    }

    public UnifiedRoleManagementPolicyRequest roleManagementPolicies(String id) {
        return new UnifiedRoleManagementPolicyRequest(contextPath.addSegment("roleManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyCollectionRequest roleManagementPolicies() {
        return new UnifiedRoleManagementPolicyCollectionRequest(
                        contextPath.addSegment("roleManagementPolicies"), Optional.empty());
    }

    public UnifiedRoleManagementPolicyAssignmentRequest roleManagementPolicyAssignments(String id) {
        return new UnifiedRoleManagementPolicyAssignmentRequest(contextPath.addSegment("roleManagementPolicyAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRoleManagementPolicyAssignmentCollectionRequest roleManagementPolicyAssignments() {
        return new UnifiedRoleManagementPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("roleManagementPolicyAssignments"), Optional.empty());
    }

}
