package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerTask;

@JsonIgnoreType
public class PlannerTaskRequest extends EntityRequest<PlannerTask> {

    public PlannerTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerTask.class, contextPath, value, false);
    }

    public PlannerAssignedToTaskBoardTaskFormatRequest assignedToTaskBoardFormat() {
        return new PlannerAssignedToTaskBoardTaskFormatRequest(contextPath.addSegment("assignedToTaskBoardFormat"), Optional.empty());
    }

    public PlannerBucketTaskBoardTaskFormatRequest bucketTaskBoardFormat() {
        return new PlannerBucketTaskBoardTaskFormatRequest(contextPath.addSegment("bucketTaskBoardFormat"), Optional.empty());
    }

    public PlannerTaskDetailsRequest details() {
        return new PlannerTaskDetailsRequest(contextPath.addSegment("details"), Optional.empty());
    }

    public PlannerProgressTaskBoardTaskFormatRequest progressTaskBoardFormat() {
        return new PlannerProgressTaskBoardTaskFormatRequest(contextPath.addSegment("progressTaskBoardFormat"), Optional.empty());
    }

}
