package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerRoster;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerRosterMemberCollectionRequest;

@JsonIgnoreType
public class PlannerRosterRequest extends EntityRequest<PlannerRoster> {

    public PlannerRosterRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerRoster.class, contextPath, value, false);
    }

    public PlannerRosterMemberRequest members(String id) {
        return new PlannerRosterMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerRosterMemberCollectionRequest members() {
        return new PlannerRosterMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), Optional.empty());
    }

}
